﻿using System;
using VIRP.CRS.BO;

namespace VIRP.EFR.BO
{
    [Serializable]
    public class PatientSummary
    {
        public int Id { get; }
        public string FullName { get; }
        public string Icn { get; }
        public string Snum { get; }

        public PatientSummary(PATIENT patient, PATIENT_REG patientReg)
        {
            this.Id = patient.PATIENT_ID;
            this.Icn = patient.PatientICN;
            this.Snum = patientReg != null ? patientReg.Snum : "Unknown";

            this.FullName = this.PatientFullName(patient.LAST_NAME, patient.FIRST_NAME, patient.MIDDLE_NAME);
        }

        protected string PatientFullName(string lastName, string middleName, string firstName)
        {
            const string FirstLastBase = "{0}, {1}";
            const string FullNameBase = "{0}, {1} {2}";

            if (string.IsNullOrEmpty(lastName) && string.IsNullOrEmpty(middleName) && string.IsNullOrEmpty(firstName))
                return "Invalid Patient Name";

            if (string.IsNullOrEmpty(middleName) && string.IsNullOrEmpty(firstName))
                return lastName;

            return string.IsNullOrEmpty(middleName) ? string.Format(FirstLastBase, lastName, firstName) 
                : string.Format(FullNameBase, lastName, firstName, middleName);
        }
    }
}